//Dustin Soodak
#include "MiscHardware.h"
#include "Navigation.h"
#include <Adafruit_NeoPixel.h>

// ***************************************************
// Misc Hardware
// ***************************************************




void HardwareBegin(void){
  MotorsBegin();
  pinMode(Edge_Lights,OUTPUT);
  digitalWrite(Edge_Lights,0);
  pinMode(Source_Select,OUTPUT);
  digitalWrite(Source_Select,0);
  
  pinMode(Light_Bus_BTN1,INPUT_PULLUP);
  Serial.begin(SERIAL_SPEED);//Serial.begin(9600);
  
  pinMode(_38kHz_Rx,INPUT_PULLUP);
  
  pinMode(IR_Send,OUTPUT);
  digitalWrite(IR_Send,0);
  pinMode(IR_Enable_Front,OUTPUT);
  digitalWrite(IR_Enable_Front,1);
  pinMode(IR_Enable_RearLeft,OUTPUT);
  digitalWrite(IR_Enable_RearLeft,1);
  pinMode(IR_Enable_RearRight,OUTPUT);
  digitalWrite(IR_Enable_RearRight,1);
  
  
}



char Mode_ButtonOrPixels=99;
void SwitchButtonToPixels(void){
  //if(!(Mode_ButtonOrPixels==1)){
    pixels.begin();
    Mode_ButtonOrPixels=1;
  //}
}
void SwitchPixelsToButton(void){  
  //if(!(Mode_ButtonOrPixels==0)){
    pinMode(Light_Bus_BTN1,INPUT_PULLUP); 
    delay(1);
    Mode_ButtonOrPixels=0;
  //}
}
//char Mode_SerialOrMotors=99;
void SwitchSerialToMotors(void){
  //if(!(Mode_SerialOrMotors==1)){
    Serial.end();
    pinMode(MotorDirection_Left, OUTPUT);
    pinMode(MotorDirection_Right, OUTPUT);
    //Mode_SerialOrMotors=1;
  //}
}
void SwitchMotorsToSerial(void){
  //if(!(Mode_SerialOrMotors==0)){
    pinMode(MotorDirection_Left, INPUT);
    Serial.begin(SERIAL_SPEED);//Serial.begin(9600);
    //Mode_SerialOrMotors=0;
  //}
}

char ButtonPressed(void){
  return (digitalRead(Light_Bus_BTN1)==0);
}


int LeftMotor;
int RightMotor;
void MotorsBegin(void){
  LeftMotor=0;
  RightMotor=0;
  pinMode(MotorDirection_Left, OUTPUT);
  pinMode(MotorDirection_Right, OUTPUT);
  analogWrite(MotorDrive_Left,0);
  analogWrite(MotorDrive_Right,0);  
}
void Motors(int LeftMotorSpeed, int RightMotorSpeed){
  if(LeftMotorSpeed>MOTOR_MAX)
    LeftMotorSpeed=MOTOR_MAX;
  if(LeftMotorSpeed<-MOTOR_MAX)
    LeftMotorSpeed=-MOTOR_MAX;
  if(RightMotorSpeed>MOTOR_MAX)
    RightMotorSpeed=MOTOR_MAX;
  if(RightMotorSpeed<-MOTOR_MAX)
    RightMotorSpeed=-MOTOR_MAX;
  LeftMotor=LeftMotorSpeed;
  RightMotor=RightMotorSpeed;
  if(LeftMotor<0){
    digitalWrite(MotorDirection_Left,0);
    //Serial.print("left - ");
  }
  else
    digitalWrite(MotorDirection_Left,1);
  if(RightMotor<0){
    digitalWrite(MotorDirection_Right,0);
    //Serial.print("right - ");
  }
  else
    digitalWrite(MotorDirection_Right,1);
    
  analogWrite(MotorDrive_Left,abs(LeftMotor));
  analogWrite(MotorDrive_Right,abs(RightMotor));
}

void EdgeLightsOn(void){
  digitalWrite(Edge_Lights,1);
}
void EdgeLightsOff(void){
  digitalWrite(Edge_Lights,0);
}
void SwitchAmbientToEdge(void){
  digitalWrite(Source_Select,1);
}
void SwitchEdgeToAmbient(void){
  digitalWrite(Source_Select,0);
}
int ReadLeftLightSensor(void){
  analogRead(LightSense_Left);
}
int ReadRightLightSensor(void){
  analogRead(LightSense_Right);
}
int ReadRearLightSensor(void){
  analogRead(LightSense_Rear);
}


int RightLightLevel,LeftLightLevel,RearLightLevel,RightEdgeLightLevel,LeftEdgeLightLevel;
int RearAmbientLightLevel,RightAmbientLightLevel,LeftAmbientLightLevel;
void ReadEdgeLightSensors(char Averages){
  int i;
  int templeft,tempright;  
  SwitchAmbientToEdge();
  EdgeLightsOff(); 
  LeftEdgeLightLevel=0;
  RightEdgeLightLevel=0;
  for(i=0;i<Averages;i++){
    templeft=ReadLeftLightSensor();
    tempright=ReadRightLightSensor();              
    EdgeLightsOn();
    LeftEdgeLightLevel+=ReadLeftLightSensor()-templeft;
    RightEdgeLightLevel+=ReadRightLightSensor()-tempright;
    EdgeLightsOff();    
  }
  if(LeftEdgeLightLevel<0) LeftEdgeLightLevel=0; else LeftEdgeLightLevel/=Averages;
  if(RightEdgeLightLevel<0) RightEdgeLightLevel=0; else RightEdgeLightLevel/=Averages;
}

int LeftEdgeArray[8];
int RightEdgeArray[8];
char EdgeArrayPos=0;
int LeftEdgeSensorAverage=0,RightEdgeSensorAverage=0;
int LeftEdgeSensorAverageTimes8=0,RightEdgeSensorAverageTimes8=0;
int LeftEdgeSensorValue=0,RightEdgeSensorValue=0;
void ResetLookAtEdge(void){
  char i;
  for(i=0;i<8;i++){
    LeftEdgeArray[i]=0;
    RightEdgeArray[i]=0;
  }
  EdgeArrayPos=0;
  LeftEdgeSensorAverage=0;
  LeftEdgeSensorAverageTimes8=0;
  RightEdgeSensorAverage=0;
  RightEdgeSensorAverageTimes8=0;
  for(i=0;i<8;i++){
    LookAtEdge(); 
  }
}
void LookAtEdge(void){//note: ir remote controls don't usually get into the edge sensors
  SwitchAmbientToEdge();
  EdgeArrayPos=(EdgeArrayPos+1)&7;// pos=(pos+1) mod 8
  LeftEdgeSensorAverageTimes8-=LeftEdgeArray[EdgeArrayPos];
  RightEdgeSensorAverageTimes8-=RightEdgeArray[EdgeArrayPos];
  //First time
  EdgeLightsOn();
  delayMicroseconds(5);   
  LeftEdgeSensorValue=ReadLeftLightSensor();
  RightEdgeSensorValue=ReadRightLightSensor();   
  EdgeLightsOff();
  delayMicroseconds(5);  
  LeftEdgeSensorValue-=ReadLeftLightSensor();
  RightEdgeSensorValue-=ReadRightLightSensor();
  //Second time
  /*EdgeLightsOn();
  delayMicroseconds(2);   
  LeftEdgeSensorValue+=ReadLeftLightSensor();
  RightEdgeSensorValue+=ReadRightLightSensor();   
  EdgeLightsOff();
  delayMicroseconds(2);  
  LeftEdgeSensorValue-=ReadLeftLightSensor();
  RightEdgeSensorValue-=ReadRightLightSensor();*/
  //Process data
  if(LeftEdgeSensorValue<0)//so can always use "/2" -> ">>1" trick so no divisions have to be done.
    LeftEdgeSensorValue=0;
  if(RightEdgeSensorValue<0){//so can always use "/2" -> ">>1" trick so no divisions have to be done.
    RightEdgeSensorValue=0; 
  }
  LeftEdgeArray[EdgeArrayPos]=LeftEdgeSensorValue;
  RightEdgeArray[EdgeArrayPos]=RightEdgeSensorValue;
  LeftEdgeSensorAverageTimes8+=LeftEdgeSensorValue;
  RightEdgeSensorAverageTimes8+=RightEdgeSensorValue;
  LeftEdgeSensorAverage=LeftEdgeSensorAverageTimes8>>3;
  RightEdgeSensorAverage=RightEdgeSensorAverageTimes8>>3;
}

char LookForEdge(void){
  char Left=0,Right=0;
  int LastLeft,LastRight;
  LookAtEdge();
  Left=(LeftEdgeSensorValue<LeftEdgeSensorAverage-(LeftEdgeSensorAverage>>3))?Left+1:0;//"val-(val>>3)"  -> "val*7/8"
  Right=(RightEdgeSensorValue<RightEdgeSensorAverage-(RightEdgeSensorAverage>>3))?Right+1:0;//"val-(val>>3)"  -> "val*7/8"
  if(Left || Right){   
    LastLeft=LeftEdgeSensorValue;
    LastRight=RightEdgeSensorValue; 
    LookAtEdge();
    if(Left)
      Left=(LeftEdgeSensorValue<LeftEdgeSensorAverage-(LeftEdgeSensorAverage>>2))?Left+1:0;//"val-(val>>2)"  -> "val*6/8"
    if(Right)
      Right=(RightEdgeSensorValue<RightEdgeSensorAverage-(RightEdgeSensorAverage>>2))?Right+1:0;//"val-(val>>2)"  -> "val*6/8"
  }
  return ((Left==2?2:0))|(Right==2?1:0);
}

void ReadSideSensors(void){
  ReadSideSensors_Restart:
  //check for IR receiving (to make sure it doesn't interfere with object detection)
  //if(IRReceiving) Serial.print("_");
  //while(IRReceiving){};
  //
  digitalWrite(IR_Send,0);
  digitalWrite(IR_Enable_Front,1);
  digitalWrite(IR_Enable_RearLeft,1);
  digitalWrite(IR_Enable_RearRight,1);
  //ReadEdgeLightSensors();
  SwitchEdgeToAmbient();
  LeftAmbientLightLevel=ReadLeftLightSensor();
  RightAmbientLightLevel=ReadRightLightSensor();
  RearAmbientLightLevel=ReadRearLightSensor();
  digitalWrite(IR_Send,1); 
  //PORTD|=(1<<7);
  //DDRD|=(1<<7); 
  /*if(PORTD&(1<<7)){
        PORTD&=~(1<<7);
        PORTD|=(1<<7);
    }
    else{
        PORTD|=(1<<7);
        PORTD&=~(1<<7);
    }*/
  delayMicroseconds(200);//delayMicroseconds(20);
  LeftLightLevel=ReadLeftLightSensor()-LeftAmbientLightLevel;
  RightLightLevel=ReadRightLightSensor()-RightAmbientLightLevel;
  RearLightLevel=ReadRightLightSensor()-RearAmbientLightLevel;
  digitalWrite(IR_Send,0);  
  //PORTD&=~(1<<7);
  /*if(PORTD&(1<<7)){
        PORTD&=~(1<<7);
        PORTD|=(1<<7);
    }
    else{
        PORTD|=(1<<7);
        PORTD&=~(1<<7);
    }*/
  delayMicroseconds(20);//delayMicroseconds(20);
  if(LeftLightLevel<0) LeftLightLevel=0;
  if(RightLightLevel<0) RightLightLevel=0;  
  if(RearLightLevel<0) RearLightLevel=0;  
  //
  //Simple check for IR receiving (to make sure it doesn't interfere with object detection)
  delayMicroseconds(100);
  //if(IRReceiving){
  //  Serial.print("!");
  //  goto ReadSideSensors_Restart;
  //}
}
  

/*
void ReadAllLightSensors(void){
  int templeft,tempright,temprear;  
  digitalWrite(IR_Send,0);
  digitalWrite(IR_Enable_Front,1);
  digitalWrite(IR_Enable_RearLeft,1);
  digitalWrite(IR_Enable_RearRight,1);
  ReadEdgeLightSensors();
  SwitchEdgeToAmbient();  
  for(i=0;i<8;i++){
    templeft=ReadLeftLightSensor();
    tempright=ReadRightLightSensor();   
    temprear=ReadRearLightSensor();      
    digitalWrite(IR_Send,1);  
    delayMicroseconds(10);
    LeftLightLevel+=ReadLeftLightSensor()-templeft;
    RightLightLevel+=ReadRightLightSensor()-tempright;
    RearLightLevel+=ReadRearLightSensor()-temprear;
    digitalWrite(IR_Send,0);               
    delayMicroseconds(10);        
  }
  if(LeftLightLevel<0) LeftLightLevel=0; else LeftLightLevel>>=3;
  if(RightLightLevel<0) RightLightLevel=0; else RightLightLevel>>=3;
  if(RearLightLevel<0) RearLightLevel=0; else RearLightLevel>>=3;  
}
*/
void ModulateIR(char Level){
  if(Level){
    digitalWrite(IR_Enable_Front,1);
    digitalWrite(IR_Enable_RearLeft,1);
    digitalWrite(IR_Enable_RearRight,1);
  }
  else{
    digitalWrite(IR_Enable_Front,0);
    digitalWrite(IR_Enable_RearLeft,0);
    digitalWrite(IR_Enable_RearRight,0);
  }
}

void TxIR(char *Data, int Length){
    int i;
    char j;
    const uint16_t Freq=38000,UsOn=5; //For R2=2k pull up, 8 us delay before pin falls. Inputs (28000,5) give a decent square wave in this case. 
    ModulateIR(1);
    PlayChirpIR(Freq,UsOn);
    delayMicroseconds(9000);
    ModulateIR(0);//note: ModulateIR(0) turns off IR 38khz out but this makes receiver voltage go high.
    delayMicroseconds(4500);
    ModulateIR(1);
    delayMicroseconds(600);
    for(i=0;i<Length;i++){      
      for(j=0;j<8;j++){
        ModulateIR(0);
        if((Data[i])&(1<<j))
          delayMicroseconds(1600);
        else
          delayMicroseconds(525);
        ModulateIR(1);
        delayMicroseconds(600);
      }      
    }//end for(i=0;i<Length;i++)    
    ModulateIR(0);
    PlayChirpIR(38000, 0);
}//end TxIR()


int IRTransitionCount=0;
char IRBitNum=0,IRByte=0,IRNumOfBytes=0;
unsigned char IRBytes[20];
uint16_t IRPrevTime=0,IRTime;
uint32_t MsAtLastIR=0;//used for end of communication timeout
volatile char IRReceiving=0;
char IRActive=0;
void RxIRRestart(void){
  detachInterrupt(1);//interrupt 1 is I/O 3 which is _38kHz_R
  TCCR1A = 0x00;          // COM1A1=0, COM1A0=0 => Disconnect Pin OC1 from Timer/Counter 1 -- PWM11=0,PWM10=0 => PWM Operation disabled
  // ICNC1=0 => Capture Noise Canceler disabled -- ICES1=0 => Input Capture Edge Select (not used) -- CTC1=0 => Clear Timer/Counter 1 on Compare/Match
  // CS12=0 CS11=1 CS10=1 => Set prescaler to clock/64
  TCCR1B = 0x03;          // 8MHz clock with prescaler 0x03 means TCNT1 increments every 8uS
  // ICIE1=0 => Timer/Counter 1, Input Capture Interrupt Enable -- OCIE1A=0 => Output Compare A Match Interrupt Enable -- OCIE1B=0 => Output Compare B Match Interrupt Enable
  // TOIE1=0 => Timer 1 Overflow Interrupt Enable
  TIMSK1 = 0x00;          
  pinMode(_38kHz_Rx, INPUT);  
  IRReceiving=0;  
  IRTransitionCount=0;
  IRPrevTime=0;
  MsAtLastIR=0;IRBitNum=0;IRByte=0;IRNumOfBytes=0;
  IRActive=1;
  attachInterrupt(1, IRHandler, CHANGE);//interrupt 1 is I/O 3 which is _38kHz_Rx  
}
void RxIRStop(void){
  detachInterrupt(1);//interrupt 1 is I/O 3 which is _38kHz_Rx    
  TCCR1B=0;//turn off timer        
  pinMode(_38kHz_Rx, INPUT);  
  
  MsAtLastIR=0;//so IRHandler() recognizes it as first falling edge of next transition
  IRReceiving=0;
  IRActive=0;
  //IRTransitionCount=0;//so IsIRDone() does not expect anything just because RxIRStop() called.
}


void IRHandler(void){//using interrupt 1 is I/O 3 which is _38kHz_Rx  
  int16_t dTime;
  char Level;
  noInterrupts();
  IRTime=TCNT1;
  delayMicroseconds(5);//debounce (don't know if mecessary) 
  interrupts(); 
  Level=digitalRead(_38kHz_Rx);  
  /*
   DDRD|=(1<<7); 
   if(Level)
     PORTD|=(1<<7);
   else
     PORTD&=~(1<<7);
   */
  if(!Level)
    IRReceiving=1;
  if(millis()-MsAtLastIR>100){
    TCNT1=0;
    IRPrevTime=0;
    IRTransitionCount=0;
    IRBitNum=0;IRNumOfBytes=0;IRByte=0;  
    //IRReceiving=1;  
  }  
  else{  
    if(IRTime>IRPrevTime)
      dTime=IRTime-IRPrevTime;
    else
      dTime=0xFFFF-IRPrevTime+1+IRTime;   
    IRPrevTime=IRTime;    
    dTime=dTime<<3;
    if(IRTransitionCount>=3 && (IRTransitionCount&1)){//should be high
      if(dTime>1000){
        IRByte|=(1<<IRBitNum); 
      }
      IRBitNum++;
      if(IRBitNum>7){
        if(IRNumOfBytes<20){
          IRBytes[IRNumOfBytes]=IRByte;
          IRNumOfBytes++;
        }        
        IRBitNum=0; 
        IRByte=0;               
      }      
    }
    IRTransitionCount++;
  }
  MsAtLastIR=millis();
}

char IsIRDone(void){
  return (millis()-MsAtLastIR>40 && IRTransitionCount>0);  
}

void IRMenuTest(void){
  char i,Refresh=0;
  char SoundType=0;
  int Heading;
  uint8_t LEDsSelected=0;
  uint8_t Color=1,r,g,b;
  RxIRRestart();
  Heading=GetDegrees();
  Serial.println("receiving IR");
  SwitchPixelsToButton();
  while(/*Serial.available()==0 &&*/ !ButtonPressed()){
    
    SwitchButtonToPixels();
    if(IsIRDone()){
      RxIRStop();
      Serial.print("length ");
      Serial.println((int)IRNumOfBytes,DEC);
      for(i=0;i<IRNumOfBytes;i++){
        Serial.println(((unsigned char)IRBytes[i]),HEX); 
      }      
      if(IRBytes[2]==0x06 && IRBytes[3]==0xF9) {//foreward
        //SetPixelRGB(5,0,0,50);SetPixelRGB(6,0,0,50);RefreshPixels();
        //delay(100);
        //SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();
        MoveStraight(Heading, 150, 50, 4000, 250);//move at heading 180, speed 200 for 600mm(about 2 ft), for max of 5000ms and keep updating position for 500ms more.      
        SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();
      }
      else if(IRBytes[2]==0x44 && IRBytes[3]==0xBB){//backward
        MoveStraight(Heading, -150, -50, 4000, 250);
        SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();
      }
      else if(IRBytes[2]==0x40 && IRBytes[3]==0xBF){//right
        RotateSimple(90, 100, -100, 1000, 250);//rotate 180 degrees to the right at speed 100, for max of 1000ms and keep updating position for 500ms more.    
        Heading+=90;
      }
      else if(IRBytes[2]==0x47 && IRBytes[3]==0xB8){//left
        RotateSimple(-90, -100, 100, 1000, 250); 
        Heading-=90;   
      }

      else if(IRBytes[2]==0x3 && IRBytes[3]==0xFC){//blank1
        PlayAnger();   
      }
      else if(IRBytes[2]==0x2 && IRBytes[3]==0xFD){//blank2
        PlayBoredom();   
      }
      else if(IRBytes[2]==0x51 && IRBytes[3]==0xAE){//blank3
        PlayExcited();   
      }
      else if(IRBytes[2]==0x50 && IRBytes[3]==0xAF){//A
        SetPixelRGB(5,50,0,0);SetPixelRGB(6,50,0,0);RefreshPixels();  
      }
      else if(IRBytes[2]==0x55 && IRBytes[3]==0xAA){//0
        SetPixelRGB(5,0,50,0);SetPixelRGB(6,0,50,0);RefreshPixels();  
      }
      else if(IRBytes[2]==0x48 && IRBytes[3]==0xB7){//B
        SetPixelRGB(5,0,0,50);SetPixelRGB(6,0,0,50);RefreshPixels();
      }
      else if(IRBytes[2]==0x9 && IRBytes[3]==0xF6){//1      
        if(LEDsSelected&(1<<0)){
          LEDsSelected&=~(1<<0);
          SoundType=2;
        }
        else{
          LEDsSelected|=(1<<0);
          SoundType=1;
        }
        Refresh=1;
      }
      else if(IRBytes[2]==0x1D && IRBytes[3]==0xE2){//2
        if(LEDsSelected&(1<<1)){
          LEDsSelected&=~(1<<1);
          SoundType=2;
        }
        else{
          LEDsSelected|=(1<<1);
          SoundType=1;
        }
        Refresh=1;
      }
      else if(IRBytes[2]==0x1F && IRBytes[3]==0xE0){//3
        if(LEDsSelected&(1<<2)){
          LEDsSelected&=~(1<<2);
          SoundType=2;
        }
        else{
          LEDsSelected|=(1<<2);
          SoundType=1;
        }
        Refresh=1;
      }
      else if(IRBytes[2]==0x19 && IRBytes[3]==0xE6){//4
        if(LEDsSelected&(1<<3)){
          LEDsSelected&=~(1<<3);
          SoundType=2;
        }
        else{
          LEDsSelected|=(1<<3);
          SoundType=1;
        }
        Refresh=1;
      }
      else if(IRBytes[2]==0x1B && IRBytes[3]==0xE4){//5
        if(LEDsSelected&(1<<4)){
          LEDsSelected&=~(1<<4);
          SoundType=2;
        }
        else{
          LEDsSelected|=(1<<4);
          SoundType=1;
        }
        Refresh=1;
      }
      else if(IRBytes[2]==0x11 && IRBytes[3]==0xEE){//6
        if(LEDsSelected&(1<<5)){
          LEDsSelected&=~(1<<5);
          SoundType=2;
        }
        else{
          LEDsSelected|=(1<<5);
          SoundType=1;
        }
        Refresh=1;          
      }
      else if((IRBytes[2]==0x45 && IRBytes[3]==0xBA)){//if +
        Color=(Color+1)%10;
        Refresh=1;
      }
      else if(IRBytes[2]==0x1 && IRBytes[3]==0xFE){ //-  
        if(Color)
          Color--;
        else
          Color=9; 
        Refresh=1;
      }
      else if(IRBytes[2]==0xD && IRBytes[3]==0xF2){//C //else if(IRBytes[2]==0x9 && IRBytes[3]==0xF6)//1
        MoveStraight(Heading, 150, 300, 4000, 300);
        RotateSimple(180, 100, -100, 1000, 300);
        MoveStraight(Heading+180, 150, 300, 4000, 300);
        RotateSimple(-180, -100, 100, 1000, 300);
        Refresh=1;//SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();
      }
      else if(IRBytes[2]==0x15 && IRBytes[3]==0xEA){//D//else if(IRBytes[2]==0x1D && IRBytes[3]==0xE2)//2
        MoveStraight(Heading, 150, 600, 4000, 300);
        RotateSimple(180, 100, -100, 1000, 300);
        MoveStraight(Heading+180, 150, 600, 4000, 300);
        RotateSimple(-180, -100, 100, 1000, 300);
        Refresh=1;//SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();
      }  
      else if(IRBytes[2]==0x8 && IRBytes[3]==0xF7){//E//else if(IRBytes[2]==0x1F && IRBytes[3]==0xE0)//3
        MoveStraight(Heading, 150, 900, 4000, 300);
        RotateSimple(180, 100, -100, 1000, 300);
        MoveStraight(Heading+180, 150, 900, 4000, 300);
        RotateSimple(-180, -100, 100, 1000, 300);
        Refresh=1;//SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();
      }  
      else if(IRBytes[2]==0x52 && IRBytes[3]==0xAD){//stop
        SetAllPixelsRGB(0,0,0);RefreshPixels();
        Color=1;
        LEDsSelected=0;
      }  
      else{
        SwitchMotorsToSerial();      
        Serial.print((unsigned char)IRBytes[2],HEX);Serial.print("\t");Serial.println((unsigned char)IRBytes[3],HEX);
        delay(10);
        SwitchSerialToMotors();        
      }
      
      if(Refresh){
        Refresh=0;
        Serial.print("Col: ");Serial.print(Color,DEC);Serial.print(" Sel: ");Serial.println(LEDsSelected,2);
        switch(Color){
        case 0: r=0;g=0;b=0; break;
        case 1: r=50;g=0;b=0; break;
        case 2: r=25;g=25;b=0; break;
        case 3: r=0;g=50;b=0; break;
        case 4: r=0;g=25;b=25; break;
        case 5: r=0;g=0;b=50; break;
        case 6: r=25;g=0;b=25; break;
        case 7: r=30;g=10;b=10; break;
        case 8: r=25;g=25;b=25; break;
        case 9: r=100;g=100;b=100; break;
        }
        for(i=0;i<6;i++){
          if(LEDsSelected&(1<<i))
            SetPixelRGB(i+1,r,g,b);
        }
        RefreshPixels();
        if(SoundType==1){
          PlayChirp(NOTE_CS6,50);
          delay(50);
          PlayChirp(NOTE_F6,50);
          delay(80);
          PlayChirp(NOTE_F6,0);
          delay(50);
        }
        else if(SoundType==2){
          PlayChirp(NOTE_F6,50);
          delay(50);
          PlayChirp(NOTE_CS6,50);
          delay(80);
          PlayChirp(NOTE_F6,0);
          delay(50);
        }
        else{
          delay(100);
        }
        SoundType=0;
      }//end if(Refresh)
      
      RxIRRestart();//resets
    }//end if(IsIRDone()
    SwitchPixelsToButton();
    delay(10);
  }
  RxIRStop();
  Serial.read();   
  Serial.println("done"); 
}




// ***************************************************
// end Misc Hardware
// ***************************************************

// ***************************************************
// Pixels
// ***************************************************


Adafruit_NeoPixel pixels = Adafruit_NeoPixel(NUM_PIXELS, Light_Bus_BTN1, NEO_GRB + NEO_KHZ800);
void SetPixelRGB(int Pixel, int Red, int Green, int Blue){
  if(Pixel>6)
    Pixel=6;
  if(Pixel<1)
    Pixel=1;
  pixels.setPixelColor(Pixel-1, pixels.Color(Red,Green,Blue));
}
void SetAllPixelsRGB(int Red, int Green, int Blue){
  char i;
  for(i=0;i<NUM_PIXELS;i++){
    pixels.setPixelColor(i, pixels.Color(Red,Green,Blue)); 
  }
  pixels.show();   
}
void RefreshPixels(void){
  pixels.show();  
}
// ***************************************************
// end Pixels
// ***************************************************


// ***************************************************
// MovementFunctions
// ***************************************************

void RotateSimple(int TurnDegrees, int left, int right, int MaxExpectedTurnTime, int MaxExpectedSkidTime){
  uint32_t timeout;
  int degr,DegrPredict,DegrInit;
  char colormode=0;
  SwitchSerialToMotors();
  if(NavigationOn){
    ZeroNavigationSensors();
    ResumeNavigation();
  }
  else
    NavigationBegin();
  
  DegrInit=GetDegrees();     
  Motors(left,right);
  timeout=millis()+MaxExpectedTurnTime;
  RestartTimer();
  while(millis()<timeout){
    if(GetTime()>100){
      switch(colormode){
      case 0:
        SetPixelRGB(5,H_Bright,0,H_Bright);SetPixelRGB(6,H_Bright,0,H_Bright);colormode=1;
      break;
      case 1:
        SetPixelRGB(5,0,0,H_Bright);SetPixelRGB(6,0,0,H_Bright);colormode=0;
      break;
      }
      RefreshPixels();
      RestartTimer(); 
    }
    SimpleGyroNavigation();
    degr=GetDegrees()-DegrInit;
    DegrPredict=degr+GetDegreesToStop(); //DegrPredict=degr+GyroDegreesToStopFromRaw(rate);//(((float)(-rate))*2000/32768)*0.1029-(24);        
    if(TurnDegrees>=0?(DegrPredict>=TurnDegrees):(DegrPredict<=TurnDegrees)){ 
      break; 
    }
  }
  Motors(0,0);     
  timeout=millis()+MaxExpectedSkidTime;
  while(millis()<timeout){
    SimpleNavigation();
  }
  PauseNavigation();
}

char RotateAccurate(int Heading, int MaxExpectedTurnTime){
  uint32_t timeout;
  int degr,skid,motor;
  char res=0;
  SwitchSerialToMotors();
  if(NavigationOn){
    ZeroNavigationSensors();
    ResumeNavigation();
  }
  else
    NavigationBegin();    
  SwitchSerialToMotors();
  timeout=millis()+MaxExpectedTurnTime;
  while(1){
    SimpleGyroNavigation();
    degr=GetDegrees()-Heading;
    skid=GetDegreesToStop();
    if(abs(degr)<2){
      Motors(0,0);
      if(GetDegreesPerSecond()==0){        
        timeout=millis()+100;
        while(millis()<timeout){
          SimpleGyroNavigation();
        }
        degr=GetDegrees()-Heading;
        if(abs(degr)<2){
          res=1;
          break;
        }
      }    
    }
    else{  
      motor=50+abs(degr+skid);
      if(motor>200)
        motor=200;      
      if(degr+skid>0)
        Motors(-motor,motor); 
      else
        Motors(motor,-motor); 
    }
    if(millis()>timeout){
      res=0;
      Motors(0,0);
      while(GetDegreesPerSecond()!=0 && millis()<timeout+500){
        SimpleGyroNavigation(); 
      }
      break;
    }
  }//end while(1)
  return res;
}//end Rotate()




void MoveStraight(int Direction, int Speed, int Distance, int MaxExpectedRunTime, int MaxExpectedSkidTime){
  
  uint32_t timeout;
  int PrevDirection,PrevPosition;//only keeping track of y-direction for now.
  int Heading,Input,Output,Proportional,Integral=0,Derivative,ProportionalPrev,dist,initdist;
  int MinLeftEdge,MinRightEdge;
  char left,right;
  signed char BackAway=0;
  SwitchSerialToMotors();
  if(NavigationOn)
    ZeroNavigationSensors();
  else{
    NavigationBegin();
    PauseNavigation();
  }

  ResetLookAtEdge();    
  
  initdist=GetPositionY();
  Heading=Direction;//GetDegrees();
  ResumeNavigation();       
  Motors(Speed,Speed);
  timeout=millis()+MaxExpectedRunTime;
  Input=GetDegrees()+GetDegreesToStop();
  ProportionalPrev=(Heading-Input);
  while(millis()<timeout){
    SimpleNavigation();
    Input=GetDegrees()+GetDegreesToStop();
    Proportional=(Heading-Input);
    Integral+=Proportional;
    Derivative=ProportionalPrev-Proportional;
    ProportionalPrev=Proportional;
    Output=Proportional/2+Integral/100;//+Derivative/100;
    Motors(Speed+Output,Speed-Output);
    dist=GetPositionY()-initdist;
    if((Distance>0 && dist>Distance) || (Distance<0 && dist<Distance))
      break;
    if(LookForEdge()){
      BackAway=LeftEdgeSensorAverage-LeftEdgeSensorValue>RightEdgeSensorAverage-RightEdgeSensorValue?1:-1;
      Motors(-200,-200);
      SetPixelRGB(5,50,0,0);SetPixelRGB(6,50,0,0);RefreshPixels();
      delay(200);
      Motors(0,0);
      delay(500);
      RotateSimple(90*BackAway, BackAway*100, -BackAway*100, 1000, 200);      
      break;
    }    
  }
  Motors(0,0);     
  timeout=millis()+MaxExpectedSkidTime;
  while(millis()<timeout){
    SimpleNavigation();
  }
}


void MoveStraightWithFullOptions(int Direction, int Speed, int Distance, int MaxExpectedRunTime, int MaxExpectedSkidTime, void (*EdgeFunction)(char), 
                             int PIDRange, float ProportionalTerm, float IntegralTerm, float DerivativeTerm){
  
   uint32_t timeout;
  int PrevDirection,PrevPosition;//only keeping track of y-direction for now.
  int Heading,Input,Output,Proportional,Integral=0,Derivative,ProportionalPrev,dist,initdist;
  int MinLeftEdge,MinRightEdge;
  char left,right,edge;
  signed char BackAway=0;
  SwitchSerialToMotors();
  if(NavigationOn)
    ZeroNavigationSensors();
  else{
    NavigationBegin();
    PauseNavigation();
  }

  ResetLookAtEdge();    
  
  initdist=GetPositionY();
  Heading=Direction;//GetDegrees();
  ResumeNavigation();       
  Motors(Speed,Speed);
  timeout=millis()+MaxExpectedRunTime;
  Input=GetDegrees()+GetDegreesToStop();
  ProportionalPrev=(Heading-Input);
  while(millis()<timeout){
    SimpleNavigation();
    Input=GetDegrees()+GetDegreesToStop();
    Proportional=(Heading-Input);
    Integral+=Proportional;
    Derivative=ProportionalPrev-Proportional;
    ProportionalPrev=Proportional;
    Output=(int)(ProportionalTerm*Proportional)+(int)(IntegralTerm*Integral)+(int)(DerivativeTerm*Derivative);
    if(Output>PIDRange)
      Output=PIDRange;
    if(Output<-PIDRange)
      Output=-PIDRange;
    Motors(Speed+Output,Speed-Output);
    dist=GetPositionY()-initdist;
    if((Distance>0 && dist>Distance) || (Distance<0 && dist<Distance))
      break;
    if(EdgeFunction){
      edge=LookForEdge();
      if(edge){
        EdgeFunction(edge);        
        break;//exit
      } 
    }   
  }
  Motors(0,0);     
  timeout=millis()+MaxExpectedSkidTime;
  while(millis()<timeout){
    SimpleNavigation(); 
  }  
}

void MoveWithOptions(int Direction, int Speed, int Distance, int MaxExpectedRunTime, int MaxExpectedSkidTime, void (*EdgeFunction)(char), char Wiggle){
  
   uint32_t timeout,totaltimeout;
  char timeoutmode=0;
  int PrevDirection,PrevPosition;//only keeping track of y-direction for now.
  int Heading,Input,Output,Proportional,Integral=0,Derivative,ProportionalPrev,dist,initdist;
  int MinLeftEdge,MinRightEdge;
  char left,right,edge;
  signed char BackAway=0;
  char colormode=0;
  SwitchSerialToMotors();
  if(NavigationOn)
    ZeroNavigationSensors();
  else{
    NavigationBegin();
    PauseNavigation();
  }

  ResetLookAtEdge();    
  ResumeNavigation(); 
  SimpleNavigation();
  initdist=GetPositionY();
  Heading=Direction;    
  Motors(Speed,Speed);
  timeout=millis()+MaxExpectedRunTime;
  Input=GetDegrees()+GetDegreesToStop();
  ProportionalPrev=(Heading-Input);
  RestartTimer();
  while(millis()<timeout){
    /*
      //flash lights (used when filming kickstarter)
      if(GetTime()>100){
      switch(colormode){
      case 0:
        SetPixelRGB(5,H_Bright,H_Bright/3,H_Bright/3);SetPixelRGB(6,H_Bright,H_Bright/3,H_Bright/3);colormode=1;
      break;
      case 1:
        SetPixelRGB(5,0,H_Bright,0);SetPixelRGB(6,0,H_Bright,0);colormode=0;
      break;
      }
      RefreshPixels();
      RestartTimer(); 
    }*/
    SimpleNavigation();    
    Input=GetDegrees()+GetDegreesToStop();
    Proportional=(Heading-Input);
    Integral+=Proportional;
    Derivative=GetDegreesPerSecond();
    ProportionalPrev=Proportional;
    if(Integral/50>100)
      Integral=5000;
    if(Integral/50<-100)
      Integral=-5000; 
    Output=Proportional+Integral/50-(Wiggle==0?(3*Derivative/4):0);
    if(Output>0)
      Output+=Wiggle;
    else if(Output<0)
      Output-=Wiggle;
    if(Output>100)
      Output=100;
    if(Output<-100)
      Output=-100;    
    Motors(Speed+Output,Speed-Output);
    dist=GetPositionY()-initdist;
    if((Distance>0 && dist>Distance) || (Distance<0 && dist<Distance))
      break;
    if(EdgeFunction){
      edge=LookForEdge();
      if(edge){
        EdgeFunction(edge);        
        break;//exit
      }
    }
  }
  Motors(0,0);     
  timeout=millis()+MaxExpectedSkidTime;
  totaltimeout=timeout;
  while(millis()<timeout){
    SimpleNavigation(); 
    if(GetDegreesPerSecond()==0){
      if(timeoutmode==0){
        timeout=millis()+100;//see if it will stay still for 100ms
        timeoutmode=1;
      }
    }
    else{
      if(timeoutmode==1){
        timeout=totaltimeout;
        timeoutmode=0;
      }
    }
  }
  SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);colormode=0;
}


void MaintainPositionExample(void){
  int dpsprev,accel,dps,deg,initdeg,inity,y;
  char moving=0;
  if(NavigationOn){
    ZeroNavigationSensors();
  }
  else{
    NavigationBegin();
  }
  initdeg=GetDegrees();
  inity=GetPositionY();
  SwitchMotorsToSerial();
  ResumeNavigation();
  dpsprev=GetDegreesPerSecond();
  RestartTimer();
  SwitchPixelsToButton();
  while(1){   
    SimpleNavigation();  // call this enough that buffers in accel and gyro don't overflow
    dps=GetDegreesPerSecond();
    accel=GetAccelerationY();
    y=GetPositionY();
    if(GetTime()>100){   
      Serial.print(GyroFifoOverflow,DEC);
      Serial.print(AccelFifoOverflow,DEC);
      Serial.print(" dps ");
      Serial.print(dps,10);
      Serial.print(" drel ");
      Serial.print(GetDegrees()-initdeg,10);
      Serial.print(" y ");
      Serial.print(y);
      Serial.print(" init ");
      Serial.print(inity);
      Serial.print(" ac ");
      Serial.println(accel);
      //ZeroNavigation();
      
      if(moving){
        Serial.print("m");
        if(abs(accel)<500 && abs(dps)<2){ 
          moving--;   
          if(moving==0){        
          PauseNavigation();     
          Serial.println("\r\nstopped"); 
          SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();   
          delay(1000);
          SwitchButtonToPixels();
          SetPixelRGB(5,25,25,0);SetPixelRGB(6,25,25,0);RefreshPixels();     
          deg=GetDegrees();
          if(abs(deg)>20){
            if(deg>0)
              RotateSimple(-deg, -100, 100, 1000, 500);
            else
              RotateSimple(-deg, 100, -100, 1000, 500);
            SwitchMotorsToSerial();
            Serial.print("deg ");
            Serial.println(-deg,DEC);  
            delay(200);
            SwitchButtonToPixels();
            SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels(); 
            AccelPosition[1]=0;//since this will be inaccurate after a spin
          }
          else{            
            if(GetPositionY()>0)
              MoveWithOptions(0, -150, -GetPositionY(), 3000, 300, 0,0); 
            else
              MoveWithOptions(0, 150, -GetPositionY(), 3000, 300, 0,0); 
            SwitchMotorsToSerial();
            Serial.print("y ");
            Serial.println(-GetPositionY(),DEC);             
            SwitchButtonToPixels();
            SetPixelRGB(5,0,50,0);SetPixelRGB(6,0,50,0);RefreshPixels();
            delay(200);
            SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();             
          }
          ZeroNavigationSensors();           
          ResumeNavigation();
          delay(10);
          SimpleNavigation();
          initdeg=GetDegrees(); 
          inity=GetPositionY();
          }//end if(moving==0)
        }//end if(abs(accel)<50 && abs(dps)<2)
        else
          moving=3;
        
      }//end if(moving)
      else{
        if(abs(y-inity)<1 && abs(dps)<2){          
          AccelVelocity[1]=0;//DON'T calibrate sensors but definitely get rid of excess velocity if most likely drift. don't change degrees, though.
          Serial.print("r"); 
        }
        else{
         Serial.print("!");
         //Serial.println(y);
         SwitchButtonToPixels();
         SetPixelRGB(5,50,0,0);SetPixelRGB(6,50,0,0);RefreshPixels();
         moving=3;
        }        
      }//end if(moving) else
             
       RestartTimer();
     }//end if(GetTime()>100) 
     
     
  }//end while(!ButtonPressed())
}


void ExploreExample(int Speed, unsigned int MaxExpectedRunTime, int MaxExpectedSkidTime){
  
  uint32_t timeout;
  int PrevDirection,PrevPosition;//only keeping track of y-direction for now.
  int Heading,Input,Output,Proportional,Integral=0,Derivative,ProportionalPrev,dist,initdist;
  int MinLeftEdge,MinRightEdge;
  int Brightest=0,Dimmest=0;
  char AddictedToLight=0;
  char Hypnotized=0;
  int OriginalSpeed=Speed;
  int HypnotizedSpeed;
  char left,right,edge,both,detect;
  char GoingDirectionOfMotors=0,Panic=0;
  signed char PrevDirectionOfMotors=0;
  int BackAway=0,BackAwayPrev=0;
  int Time;
  char ShortTimes=0;
  char LeftTimes=0,RightTimes=0,SwitchTimes=0;
  SwitchSerialToMotors();
  if(NavigationOn)
    ZeroNavigationSensors();
  else{
    NavigationBegin();
    PauseNavigation();
  }
  Heading=GetDegrees();
    
  ResetLookAtEdge();
  SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();      
  
  ResumeNavigation();       
  Motors(Speed,Speed);
  timeout=millis()+MaxExpectedRunTime;
  RxIRRestart();
  RestartTimer();
  AddictedToLight=1;//change back!!!
  while(1/*millis()<timeout*/){
    SimpleGyroNavigation();
    //
    Input=GetDegrees()+GetDegreesToStop();
    //
      
    if(AddictedToLight){
      if(RearAmbientLightLevel>RightAmbientLightLevel && RearAmbientLightLevel>LeftAmbientLightLevel)
        Heading=Input+20;
      else if(RightAmbientLightLevel>LeftAmbientLightLevel)
        Heading=Input+10;
      else
        Heading=Input-10;
    }
    if(Hypnotized)
      Speed=HypnotizedSpeed; 
    else
      Speed=OriginalSpeed;
    //
    if(Input-Heading>5){
      Motors(Speed-50,Speed+50);
      if(GetDegreesPerSecond()<-20)
        GoingDirectionOfMotors=1;
      else if(GoingDirectionOfMotors && PrevDirectionOfMotors==-1){
        Panic=1;
      }
      PrevDirectionOfMotors=-1;
    }
    else if(Input-Heading<-5){
      Motors(Speed+50,Speed-50);      
      if(GetDegreesPerSecond()>20)
        GoingDirectionOfMotors=1;
      else if(GoingDirectionOfMotors && PrevDirectionOfMotors==1){
        Panic=1;
      }
      PrevDirectionOfMotors=1;
    }
    else{
      Motors(Speed,Speed);
      GoingDirectionOfMotors=0;
      PrevDirectionOfMotors=0;
    }
    ReadSideSensors();
    //
    Brightest=0;
    Dimmest=2000;
    if(RightAmbientLightLevel>LeftAmbientLightLevel){
      if(RearAmbientLightLevel>RightAmbientLightLevel){
        Brightest=RearAmbientLightLevel;
        Dimmest=LeftAmbientLightLevel;
      }
      else if(RearAmbientLightLevel<LeftAmbientLightLevel){
        Brightest=RightAmbientLightLevel;
        Dimmest=RearAmbientLightLevel;
      }
      else{
       Brightest=RightAmbientLightLevel;
       Dimmest=LeftAmbientLightLevel;
      }
    }
    else{
      if(RearAmbientLightLevel>LeftAmbientLightLevel){
        Brightest=RearAmbientLightLevel;
        Dimmest=RightAmbientLightLevel;
      }
      else if(RearAmbientLightLevel<RightAmbientLightLevel){
        Brightest=LeftAmbientLightLevel;
        Dimmest=RearAmbientLightLevel;
      }
      else{
       Brightest=LeftAmbientLightLevel;
       Dimmest=RightAmbientLightLevel;
      }
    }
    
    
     //removed for class demo
    if(Brightest>900){//then addicted to light
      if(!AddictedToLight && !Hypnotized){
        timeout=millis()+MaxExpectedRunTime;
        AddictedToLight=1;
        Motors(0,0);
        RestartTimer();
        while(GetTime()<500){
          SimpleNavigation();
        }
        PlayExcited();               
      }      
    }      
    
    
    //
    if(0/*IsIRDone()*/){//change back!!!
      //if(IRNumOfBytes==4){
        timeout=millis()+MaxExpectedRunTime;
        RxIRStop();
        if(!Hypnotized){
          Hypnotized=1;
          AddictedToLight=0;         
          Motors(0,0);
          RestartTimer();
          while(GetTime()<500){
            SimpleNavigation();
          }
          PlayExcited();
          PlayExcited();        
          HypnotizedSpeed=0;
        }
        else{   
          if(IRBytes[2]==0x06 && IRBytes[3]==0xF6){//foreward
            HypnotizedSpeed=OriginalSpeed;
            Heading=GetDegrees();        
          }
          else if(IRBytes[2]==0x44 && IRBytes[3]==0xBB){//backward
            HypnotizedSpeed=-OriginalSpeed;
            Heading=GetDegrees();     
          }
          else if(IRBytes[2]==0x40 && IRBytes[3]==0xBF){//right
            Heading=GetDegrees()+90;     
          }
          else if(IRBytes[2]==0x47 && IRBytes[3]==0xB8){//left
            Heading=GetDegrees()-90;     
          }
          else if(IRBytes[2]==0x7 && IRBytes[3]==0xF8){//stop
            HypnotizedSpeed=0;   
            Heading=GetDegrees();
          }
          else if(IRNumOfBytes==4){
            Motors(0,0); 
            RestartTimer();
            while(GetTime()<250){
              SimpleGyroNavigation(); 
            }
            HypnotizedSpeed=0;   
            Heading=GetDegrees();
            SwitchMotorsToSerial();      
            Serial.print((unsigned char)IRBytes[2],HEX);Serial.print("\t");Serial.println((unsigned char)IRBytes[3],HEX);
            while(GetTime()<50){
              SimpleGyroNavigation(); 
            }
            SwitchSerialToMotors(); 
          }
          IRBytes[2]=0x00;IRBytes[3]=0x00;
        }//end if(!Hypnotized) else
      //}//end if(IRNumOfBytes==4)
      RxIRRestart();
    }//end if(IsIRDone()
    //
     
     
    detect=0;/*=LookForEdge();*/ //change back!!!
    if(detect && !Hypnotized){
      Motors(-255,-255);
      BackAway=LeftEdgeSensorAverage-LeftEdgeSensorValue>RightEdgeSensorAverage-RightEdgeSensorValue?1:-1;
      edge=1;
    }
    if(RightLightLevel>50 || LeftLightLevel>50){
      if(!AddictedToLight && !Hypnotized){
        Motors(-255,-255);
        BackAway= LeftLightLevel>RightLightLevel?1:-1;
        edge=0;
      }
    }
    if(BackAway!=0){
      Time=GetTime();           
      RestartTimer();
      while(GetTime()<50){
        SimpleGyroNavigation(); 
      }
      LookAtEdge();
      if(edge){
        if(detect==3){
          BackAway=BackAway*2;//if both saw an edge
          SetPixelRGB(6,50,0,0);SetPixelRGB(5,50,0,0);//both
        }
        else if(detect==2){
          SetPixelRGB(6,50,0,0);SetPixelRGB(5,0,0,0);//left
        }
        else if(detect==1){
          SetPixelRGB(6,0,0,0);SetPixelRGB(5,50,0,0);//right
        }
      }
      else{
        if(RightLightLevel>50 && LeftLightLevel>50){
          BackAway=BackAway*2;//if both saw an edge
          SetPixelRGB(6,50,20,20);SetPixelRGB(5,50,20,20);//both
        }
        else if(LeftLightLevel>RightLightLevel){
          SetPixelRGB(6,50,20,20);SetPixelRGB(5,0,0,0);//left
        }
        else{
          SetPixelRGB(6,0,0,0);SetPixelRGB(5,50,20,20);//right    
        } 
      }
      RefreshPixels();
        
      //if((GetDegrees()&3)==0);//random
      //  BackAway=BackAway;
      Motors(-200,-200);

      RestartTimer();
      while(GetTime()<200){
        SimpleGyroNavigation(); 
      }
      Motors(0,0);
      if(!AddictedToLight){
        //reflect on past memories
        if(Time<500)
         ShortTimes++;
        else
         ShortTimes=0;      
        if(BackAway>0){
          RightTimes++;     
          LeftTimes=0; 
        }
        else{
          LeftTimes++; 
          RightTimes=0; 
        }
        if(BackAwayPrev==-BackAway)
          SwitchTimes++;
        else
          SwitchTimes=0;  
        if(SwitchTimes>=2 && ShortTimes>=2 && abs(BackAway)<2){//stuck in a corner
          BackAway=BackAway+BackAway*(GetDegrees()&3);        
          SetPixelRGB(6,0,0,50);SetPixelRGB(5,0,0,50);RefreshPixels();
          PlayAnger();
          SwitchTimes=0;
          ShortTimes=0;
        }
        if(LeftTimes>=6 || RightTimes>=6){//in a circular loop
          BackAway=BackAway+BackAway*(GetDegrees()&3);
          SetPixelRGB(6,0,50,0);SetPixelRGB(5,0,50,0);RefreshPixels();
          PlayBoredom();
          LeftTimes=0;
          RightTimes=0;      
        }   
      }//end if(!AddictedToLight)  
      //end reflect on past memories   
      Motors(0,0); 
      RestartTimer();
      while(GetTime()<100){
        SimpleGyroNavigation(); 
      }      
      Heading=GetDegrees()+45*BackAway;
      Motors(BackAway*100, -BackAway*100);        
      RestartTimer();
      while(GetTime()<1000 && (BackAway>0?GetDegrees()+GetDegreesToStop()<=Heading:GetDegrees()+GetDegreesToStop()>=Heading)){
        SimpleGyroNavigation(); 
      }
      Motors(0,0);      
      SwitchMotorsToSerial();
      Serial.print(detect,BIN);
      Serial.print(" L: ");
      Serial.print(LeftLightLevel,DEC);
      Serial.print(" R: ");
      Serial.print(RightLightLevel,DEC);
      Serial.print(" Back: ");
      Serial.println(BackAway,DEC);
      SwitchSerialToMotors();
      //RotateSimple(45*BackAway, BackAway*100, -BackAway*100, 1000, 200); 
      SetPixelRGB(5,50,50,50);SetPixelRGB(6,50,50,50);RefreshPixels();
      
      //SwitchMotorsToSerial();
      RestartTimer();
      while(GetDegreesToStop()!=0 &&GetTime()<500){
        //Serial.println(GetDegreesToStop(),DEC);
        SimpleNavigation();
      }
      RestartTimer();
      while(GetTime()<50){
        SimpleGyroNavigation(); 
      }
      ZeroNavigationSensors();      
      //SwitchSerialToMotors();
      SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();
      
      ResetLookAtEdge();
      //ZeroNavigationSensors();
      BackAwayPrev=BackAway;
      BackAway=0;
      RestartTimer();
      
      Panic=0; 
      GoingDirectionOfMotors=0;
      PrevDirectionOfMotors=0;
      
    }//end if(BackAway!=0)
    else if(0/*Panic*/){
      Panic=0; 
      GoingDirectionOfMotors=0;
      PrevDirectionOfMotors=0;
      Motors(150,-150);
      SetPixelRGB(5,50,0,0);SetPixelRGB(6,50,0,0);RefreshPixels();
      RestartTimer();
      while(GetTime()<500){
        SimpleGyroNavigation(); 
      }
      SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();
      Motors(0,0);
      Heading=GetDegrees();
      ResetLookAtEdge();
      RestartTimer();
    }
  }//end while(millis()<timeout)
  Motors(0,0);     
  timeout=millis()+MaxExpectedSkidTime;
  while(millis()<timeout){
    SimpleNavigation();
  }
  
  
}//end ExploreExample


// ***************************************************
// end MovementFunctions
// ***************************************************


// ***************************************************
// Timer
// ***************************************************

int32_t Timer_InitTime=0,Timer_StoppedTime=0;
char Timer_Running=0;
int32_t GetTime(void){
  if(Timer_Running){
    return millis()-(uint32_t)Timer_InitTime;
  }
  else
    return Timer_StoppedTime;
}
void RestartTimer(void){
  Timer_InitTime=millis();
  Timer_Running=1;
}
void StopTimer(void){
  if(Timer_Running){
    Timer_StoppedTime=millis()-(uint32_t)Timer_InitTime;
    Timer_Running=0;
  }
}

// ***************************************************
// end Timer
// ***************************************************

// ***************************************************
// Chirp
// ***************************************************

  //Like the ofllowing but duty cycle is also controlled
  //pinMode(Chirp,OUTPUT);
  //tone(Chirp,10000,100);
  //Should be equivalent to 
  //PlayChirp(1000,500);

  //
  //Terms:
  //TCNT1 is counter
  // goes from BOTTOM = 0x0000 to MAX = 0xFFFF in normal mode.
  //TOP can be either OCR1A or ICR1
  //
  //Table 15-4. Waveform Generation Mode Bit Description(16 different pwm modes, 2 of which are phase & freq correct)
  //Want "phase and frequency correct PWM mode" on p.130
  //Mode is set by WGM 13:0 bits.
  //Mode WGM: 13 12 11 10
  //10         1  0  1  0 PWM, Phase Correct, TOP is ICR1  [so can use OCR1A as duty cycle and OC1A as pin output]
  //
  //TCNT1 goes from BOTTOM to TOP then TOP to BOTTOM
  //TOP can be OCR1A or ICR1
  //Output Compare OC1x cleared when TCNT1=OCR1x while upcounting, and set when down counting.
  //
  // "The Output Compare Registers contain a 16-bit value that is continuously compared with the
  //counter value (TCNT1). A match can be used to generate an Output Compare interrupt, or to
  //generate a waveform output on the OC1x pin."
  //
  //Table 15-3. Compare Output Mode, when in Phase Correct and Phase and Frequency Correct mode
  //(what these bits do depends on what WGM 13:0 are set to)
  //COM1A1 COM1A0
  //     1      0    Clear OC1A on Compare Match when upcounting. Set OC1AB on Compare Match when downcounting.
  //If we want this single pin mode, can't use OCR1A for TOP since will be used for duty cycle of PWM
  //
  //"...note that the Data Direction Register (DDR) bit corresponding
  //to the OC1A or OC1B pin must be set in order to enable the output driver."
  //
  //CS12 CS11 CS10
  //off mode(all 0), set prescvaler, or external clock source
  //
  //COM1A1 COM1A0 are bits 7:6 in                   TCCR1A
  //data direction register: bit 1 of               DDRB 
  //WGM13 WGM12 are bits 4:3 in                     TCCR1B
  //WGM11 WGM10 are bits 1:0 in                     TCCR1A
  //CS12,11,10 are bits 2:0 in                      TCCR1B
  //total count (/2-1 to get period of waveform)is  ICR1
  //duty cycle (/2 to get period it is on) is       OCR1A
  //
  //TCCR1A=(TCCR1A&0b00111111)|0b01000000;
  //
  //
  //If we had the pwm output to the chirper on another pin:
  //"Using the ICR1 Register for defining TOP works well when using fixed TOP values. By using
  //ICR1, the OCR1A Register is free to be used for generating a PWM output on OC1A. However,
  //if the base PWM frequency is actively changed by changing the TOP value, using the OCR1A as
  //TOP is clearly a better choice due to its double buffer feature."
  //
  //Another doc for R/W of 16 bit registers: 
  //http://www.embedds.com/programming-16-bit-timer-on-atmega328/

uint16_t Read16Bit(uint16_t*Register){
  uint16_t res=*(uint8_t*)Register;
  res+=(*((uint8_t*)(Register))+1)<<8;
  return res;
}

void PlayChirp(unsigned int Frequency, unsigned int Amplitude){
  //Frequency is in Hz
  //Amplitude is in units of UsOn
  uint16_t temp;
  uint16_t period,dutycycle;
  uint8_t prescalerbits;
  if(Amplitude>100)
    Amplitude=100;
  if (F_CPU/Frequency/2>=0x10000){
    if(F_CPU/Frequency/2>=0x10000*8){
        prescalerbits=0b011;//prescaler 64
        period=F_CPU/Frequency/(2*16);
        dutycycle=F_CPU/1000000*Amplitude/2/64;               
    }
    else{
      prescalerbits = 0b010;// prescaler 8
      period=F_CPU/Frequency/(2*8);
      dutycycle=F_CPU/1000000*Amplitude/2/8;
    }
  }
  else{
    prescalerbits = 0b001;  //on but no prescaling
    period=F_CPU/Frequency/(2*1);
    dutycycle=F_CPU/1000000*Amplitude/2/1;
  }
  if(Amplitude==0){
    TCCR1A=0;
    TCCR1B=0;
    pinMode(Chirp,INPUT);
    
    //Serial.println("off");
  }
  else{

    TCCR1B&=~0b00000111;//turn off timer
    
    ICR1=period;
    OCR1A=dutycycle;

    TCCR1A = (0b10<<6) | 0b10;//COM1A1 COM1A0, and WGM11 WGM10
    TCCR1B = (0b10<<3) | prescalerbits;//WGM13 WGM12, and off/(on with prescaler)
    pinMode(Chirp,OUTPUT);//DDRB|=1;//make PortB pin1 an output 
 
    //    Serial.print("clock ");
    //    Serial.print(F_CPU,DEC);
    //    Serial.print(" period ");
    //    Serial.print(period,DEC);
    //    Serial.print(" 0x");
    //    Serial.print(period,HEX);
    //    Serial.print(" duty ");
    //    Serial.print(dutycycle,DEC);
    //    Serial.print(" presc bits ");
    //    Serial.println(prescalerbits,BIN);
    //    //  
    //    Serial.print("TCCR1A ");
    //    Serial.print(TCCR1A,BIN);
    //    Serial.print(" TCCR1B ");
    //    Serial.print(TCCR1B,BIN);
    //
    //    Serial.print(" ICR1 ");
    //    Serial.print(ICR1,HEX);
    //    
    //    Serial.print(" OCR1A ");
    //    Serial.print(OCR1A,HEX);
    //    
    //    Serial.print(" DDRB ");
    //    Serial.println(DDRB,BIN);
    
  }
}




void PlayChirpIR(unsigned int Frequency, unsigned int DutyCycle){//add 8 us on time (amplitude) for R2=2k pull up (for IR_Send) 
  //For R2=2k, 8 us delay before pin falls so PlayChirpIR(38000,5) is good for IR transmission.
  //Frequency is in Hz
  //Amplitude is in units of UsOn
  uint16_t temp;
  uint16_t period,dutycycle;
  uint8_t prescalerbits;
  if(DutyCycle>100)
    DutyCycle=100;
  if (F_CPU/Frequency/2>=0x10000){
    if(F_CPU/Frequency/2>=0x10000*8){
        prescalerbits=0b011;//prescaler 64
        period=F_CPU/Frequency/(2*16);
        dutycycle=F_CPU/1000000*DutyCycle/2/64;               
    }
    else{
      prescalerbits = 0b010;// prescaler 8
      period=F_CPU/Frequency/(2*8);
      dutycycle=F_CPU/1000000*DutyCycle/2/8;
    }
  }
  else{
    prescalerbits = 0b001;  //on but no prescaling
    period=F_CPU/Frequency/(2*1);
    dutycycle=F_CPU/1000000*DutyCycle/2/1;
  }
  if(DutyCycle==0){
    TCCR1A=0;
    TCCR1B=0;
    pinMode(Chirp,INPUT);
    
    //Serial.println("off");
  }
  else{
    TCCR1B&=~0b00000111;//turn off timer    
    ICR1=period;
    OCR1B=dutycycle;
    TCCR1A = (0b10<<4) | 0b10;//COM1B1 COM1B0, and WGM11 WGM10
    TCCR1B = (0b10<<3) | prescalerbits;//WGM13 WGM12, and off/(on with prescaler)    
  }
}




//else if(serdat[0]=='c'){
//  
//  pos=2;       
//  Size=StringToInt(serdat+pos,&number,DEC);
//  if(Size){
//    pos+=Size;
//    StringToInt(serdat+pos,&number2,DEC);
//    if(Size){
//       PlayChirp(number, number2); 
//       Serial.print("freq ");
//       Serial.print(number,10);
//       Serial.print(" ampl ");
//       Serial.println(number2,10);
//       delay(200);
//       PlayChirp(number, 0);
//    }
//  }
//}

void PlayAnger(void){
  char i;
  for(i=0;i<10;i++){
    PlayChirp(NOTE_C6,100);
    delay(10);
    PlayChirp(NOTE_CS6,100);   
    delay(10);  
  }
  PlayChirp(NOTE_C6,0);  
}
void PlayBoredom(void){
  char i;
  unsigned int freq,dfreq;
  dfreq=(NOTE_DS6-NOTE_C6)>>4;
  PlayChirp(NOTE_C6,100);
  delay(50);
  for(i=0;i<16;i++){    
    PlayChirp(NOTE_C6+dfreq*i,100);
    delay(10);
  }
  PlayChirp(NOTE_DS6,100);
  delay(100);
    for(i=0;i<16;i++){    
    PlayChirp(NOTE_DS6-dfreq*i,100);
    delay(10);
  }
  PlayChirp(NOTE_C6,100);
  delay(50);
  PlayChirp(NOTE_C6,0);
}
void PlayExcited(void){
  PlayChirp(NOTE_G6,100);
  delay(100);
  PlayChirp(NOTE_C7,100);
  delay(100);
  PlayChirp(NOTE_A6,100);
  delay(100);
  PlayChirp(NOTE_C7,100);
  delay(100);
  PlayChirp(NOTE_B6,100);
  delay(100);  
  PlayChirp(NOTE_G6,100);
  delay(100);
  PlayChirp(NOTE_G6,0);
}

// ***************************************************
// end Chirp
// ***************************************************

 


/*
//After IR LED goes on, 38k flickers on/off in erratic fashion (though usually almost always on for a large section) during 
//the first 10-25ms (note: pull down is on for 38k receiver). Doesn't react when IR turned off.
pinMode(IR_Send,OUTPUT);
  digitalWrite(IR_Send,0);
DDRD|=(1<<7);
  while(1){
    digitalWrite(IR_Send,1);
    PORTD&=~(1<<7);
    delayMicroseconds(5);
    PORTD|=(1<<7);
    PORTD&=~(1<<7);
    delayMicroseconds(10);
    i=0;
    while(i<70){//while(i<5000){
      i++;
      if(digitalRead(_38kHz_Rx)){
        PORTD|=(1<<7);
      }
      else{
        PORTD&=~(1<<7);
      }
    }
    digitalWrite(IR_Send,0); 
    PORTD&=~(1<<7);
    delayMicroseconds(5);
    PORTD|=(1<<7);  
    PORTD&=~(1<<7);  
    delayMicroseconds(5);
    PORTD|=(1<<7);  
    PORTD&=~(1<<7);
    delayMicroseconds(5);
    PORTD|=(1<<7);  
    PORTD&=~(1<<7);
    i=0;
    while(i<10000){
      i++;
      if(digitalRead(_38kHz_Rx)){
        PORTD|=(1<<7);
      }
      else{
        PORTD&=~(1<<7);
      }
    }
    Serial.print(".");

  }*/

